// Generated by CoffeeScript 1.7.1
var Animal, Parrot, Room, Run, Thing, braintree, bunny, canyon, copse, find, flesh, get, heroes, look, magicWords, meadow, name, orangeBoxes, player, speak, spell, spells, spill, world,
  __hasProp = {}.hasOwnProperty,
  __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

look = function() {
  var i, sibling, _i, _len, _ref, _results;
  Say(player.inside.name, "box pinned");
  Say(player.inside.description);
  i = 0;
  while (i < directions.length) {
    if (player.inside.exits[i]) {
      Say("You can go " + directions_long[i] + ".");
    }
    i++;
  }
  _ref = player.inside.contents;
  _results = [];
  for (_i = 0, _len = _ref.length; _i < _len; _i++) {
    sibling = _ref[_i];
    if (sibling !== player) {
      _results.push(Say("You see a " + sibling.name + "."));
    } else {
      _results.push(void 0);
    }
  }
  return _results;
};

spill = function(object) {
  var thing, _i, _len, _ref, _ref1, _results;
  Say(object.name + " are carrying:");
  if (((_ref = object.contents) != null ? _ref.length : void 0) > 0) {
    _ref1 = object.contents;
    _results = [];
    for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
      thing = _ref1[_i];
      _results.push(Say("- " + thing.name));
    }
    return _results;
  } else {
    return Say("nothing");
  }
};

Run = function() {
  var c, i, origin, thing, words, _i, _len, _ref, _results;
  c = _commandline.value;
  if (c === "") {
    return;
  }
  words = _commandline.value.toLowerCase().split(' ');
  i = 0;
  while (i < words.length) {
    if (synonyms[words[i]]) {
      words[i] = synonyms[words[i]];
    }
    i++;
  }
  Say(">" + _commandline.value);
  i = 0;
  while (i < directions.length) {
    if (c === directions[i] || c === directions_long[i]) {
      if (player.inside.exits[i]) {
        get(player, player.inside.exits[i]);
        look();
      } else {
        Say("You cannot go " + directions_long[i]);
      }
    }
    i++;
  }
  switch (words[0]) {
    case "look":
      if (words.length === 1) {
        look();
      } else {
        thing = find(words[1]);
        if (thing) {
          Say(thing.description);
        } else {
          Say("You cannot see a " + words[1]);
        }
      }
      break;
    case "get":
      thing = find(words[1]);
      if (thing) {
        origin = thing.inside;
        get(thing, player);
        Say("You pick up the " + thing.name + " from the " + origin.name);
      } else {
        Say("You cannot find a " + words[1]);
      }
      break;
    case "inventory":
      spill(player);
  }
  if ((_ref = magicWords[words[0]]) != null) {
    _ref.effect();
  }
  _results = [];
  for (_i = 0, _len = world.length; _i < _len; _i++) {
    thing = world[_i];
    _results.push(typeof thing.act === "function" ? thing.act() : void 0);
  }
  return _results;
};

find = function(name, container) {
  var r, thing, _i, _len, _ref, _ref1;
  if (container === void 0) {
    container = player.inside;
  }
  _ref = container.contents;
  for (_i = 0, _len = _ref.length; _i < _len; _i++) {
    thing = _ref[_i];
    if (thing.name === name) {
      return thing;
    }
    if (((_ref1 = thing.contents) != null ? _ref1.length : void 0) > 0) {
      r = find(name, thing);
      if (r !== void 0) {
        return r;
      }
    }
  }
};

get = function(thing, to) {
  var i;
  if (thing.inside) {
    i = thing.inside.contents.indexOf(thing);
    thing.inside.contents.splice(i, 1);
  }
  thing.inside = to;
  if (!to.contents) {
    to.contents = [];
  }
  return to.contents.push(thing);
};

world = [];

flesh = {
  hardness: 3,
  flexibilty: 8,
  weight: 5
};

orangeBoxes = {
  hardness: 5,
  flexibilty: 5,
  weight: 5
};

Thing = (function() {
  function Thing(list) {
    var prop;
    for (prop in list) {
      this[prop] = list[prop];
    }
    world.push(this);
  }

  Thing.prototype.name = "nameless thing";

  Thing.prototype.description = "defies description";

  Thing.prototype.inside = void 0;

  Thing.prototype.material = orangeBoxes;

  Thing.prototype.size = 5;

  return Thing;

})();

Room = (function(_super) {
  __extends(Room, _super);

  function Room() {
    return Room.__super__.constructor.apply(this, arguments);
  }

  Room.prototype.haunted = false;

  return Room;

})(Thing);

Animal = (function(_super) {
  __extends(Animal, _super);

  function Animal() {
    return Animal.__super__.constructor.apply(this, arguments);
  }

  Animal.prototype.hp = 10;

  Animal.prototype.speed = 1;

  Animal.prototype.size = 10;

  Animal.prototype.material = flesh;

  Animal.prototype.gender = "unknown";

  return Animal;

})(Thing);

Parrot = (function(_super) {
  __extends(Parrot, _super);

  function Parrot() {
    return Parrot.__super__.constructor.apply(this, arguments);
  }

  Parrot.prototype.hp = 20;

  return Parrot;

})(Animal);

bunny = new Animal({
  name: "bunny",
  description: "adorable flopsy-wopsy bunny with its original brain"
});

meadow = new Room({
  name: "meadow",
  description: "A sunny meadow with no braintrees."
});

copse = new Room({
  name: "copse",
  description: "A small copse of trees that are definately not braintrees."
});

canyon = new Room({
  name: "canyon",
  description: "Aaaaah! Aaaaaaaa! Oh my God! It's a braintreee!"
});

meadow.exits = [];

meadow.exits[4] = copse;

copse.exits = [];

copse.exits[0] = meadow;

copse.exits[4] = canyon;

canyon.exits = [];

canyon.exits[0] = copse;

player = new Animal({
  name: "Maribel",
  gender: "female"
});

braintree = new Animal({
  name: "braintree",
  act: function() {
    if (oneIn(2)) {
      switch (magnitude(2)) {
        case 0:
          return speak(this, "announces", oneOf(getWords(FUN)));
        case 1:
          return speak(this, "hisses", oneOf(getWords(0)));
        case 2:
          return speak(this, "whispers", oneOf(heroes).name);
        case 3:
          return speak(this, "announces", oneOf(Object.keys(magicWords)));
        default:
          return speak(this, "whispers", oneOf(["Aras...", "Plotkin...", "Gjisbers..."]));
      }
    }
  }
});

get(braintree, canyon);

get(player, meadow);

get(bunny, meadow);

speak = function(speaker, verb, statement) {
  var _ref;
  if (player.inside === speaker.inside) {
    Say("The " + speaker.name + " " + verb + " \"" + (capitalize(statement)) + ".\"");
    return (_ref = magicWords[statement]) != null ? _ref.effect() : void 0;
  }
};

spells = {
  prayer: {
    incantation: "xyzzy",
    effect: function() {
      return Say("The gods listen with disinterest.");
    }
  },
  pyroclasm: {
    incantation: magicWord(),
    effect: function() {
      return Say("Everything burns!");
    }
  }
};

magicWords = {};

for (name in spells) {
  spell = spells[name];
  magicWords[spell.incantation] = spell;
}

heroes = [
  player, new Animal({
    name: "Gretel",
    gender: "female"
  })
];
